function [a, theta_tilde, l_tilde, lambda, CDS_5yr] = get_portfolio_parameters(CDX, start_date_num, end_date_num)
% --------------------------------------------------------------------------------------------------
% Get parameters specific to individual CDS between start_date and end_date
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: get_portfolio_parameters(cdx_new, datenum('02/01/2006'), datenum('02/01/2006'))
% --------------------------------------------------------------------------------------------------

% Set default values
if (nargin <= 1)
    start_date_num = CDX.dates{1}(1);
    end_date_num = CDX.dates{1}(end);
end

% Determine relevant date range
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_dates = CDX.dates{1}(start_pos:end_pos);
index_members = CDX.index_members(start_pos:end_pos,:);
num_dates = length(used_dates);

% Extract parameter time series and put it into a matrix (-1 if missing)
lambda = -ones(size(index_members));
theta_tilde = -ones(num_dates, size(index_members,2));
l_tilde = -ones(num_dates, size(index_members,2));
a = -ones(size(index_members));
CDS_5yr = -ones(size(index_members));
for i=1:size(index_members,2)
    % Extract lambda_it & 5-yr CDS spread
    cds = CDX.portfolio(i);
    [trash, matching_rows, available_rows] = intersect_sorted(cds.dates{1}, used_dates);
    if isempty(CDX.portfolio(i).x0)
        CDX.portfolio(i).x0 = zeros(length(CDX.portfolio(i).dates{1}), 1);
        continue;
    end
    lambda(available_rows,i) = CDX.portfolio(i).x0(matching_rows);
    CDS_5yr(available_rows,i) = CDX.portfolio(i).market_price{1}(matching_rows);
    
    % Extract other parameters
    AJD = cds.AJD;
    % Theta_i
    if (length(AJD.theta) > 1)
        [trash, matching_rows, available_rows] = intersect_sorted(AJD.dates, used_dates);
        theta_tilde(available_rows,i) = AJD.theta(matching_rows);
    else
        theta_tilde(:,i) = AJD.theta;
    end
    % L_i
    if (length(AJD.L) > 1)
        [trash, matching_rows, available_rows] = intersect_sorted(AJD.dates, used_dates);
        l_tilde(available_rows,i) = AJD.L(matching_rows);
    else
        l_tilde(:,i) = AJD.theta;
    end
    % ai 
    if (length(cds.ai) > 1)
        [trash, matching_rows, available_rows] = intersect_sorted(cds.dates{1}, used_dates);
        a(available_rows,i) = cds.ai(matching_rows);
    else
        matching_rows = logical(is_member_sorted_c(used_dates, cds.dates{1}));
        a(matching_rows,i) = cds.ai;
    end    
end

% Calculate fraction of not available observations
% disp(sum(sum(lambda<0))/prod(size(lambda)));